# Устройство кэша данных
## План спецкурса
* Устройство аппаратной части
    * общая иерархия памяти
        * RAM
        * per-core кэши L1, L2
            * почему их несколько уровней?
              ответ: чем больше влезает, тем дольше адресация
            * про политику обновления: LRU
        * упомянуть про когенетность кэшей
        * per-platform кэши L3
            * в основном для обмена данными
    * кэш данных
        * игрушечный кэша (ассоциативности 1)
            * есть N коробочек, каждая вместимости M байт, куда можем располагать данные
            * то, куда мы кладём данные, зависят от адреса данных и только от них
                (а от чего ещё? не от самих даных же)
            * почему объединяем данные по кэш линиям?
                * чем меньше бит адресации, тем лучше для кэша (проще устройство, быстрее можем ответить)
            * слишком большие кэш линии делать тоже не умеет смысла
                * усложняется логика выбора нужных данных на стороне ядра
            * то, куда мы кладём данные, зависят от адреса данных и только от них
                (а от чего ещё? не от самих даных же)
            * структура адреса (tag, index, offset)
            * терминология
                * количество коробочек называтся sets
                * размер коробочки называется размером кэш линии
        * в чём проблема игрушечного кэша?
            * при обращении к данным, удалённым на некоторую константу, возникает проблемы
              вытеснения (возможно нужных данных). (conflict miss)
        * ассоциативность
            * увеличиваем размер каждой коробочки. Теперь у каждой коробочки есть K слотов,
              каждый из которых может хранить кэш линию.
            * больше -> лучше с точки зрения меньшей скорости выбывания полезных баллов
            * больше -> сложнее реализовать в железе
            * нарисовать картинку для assoc=2, assoc=4
    * про виртуальную адресацию
        * про режимы работы процессора
        * про переключение в user mode
        * про TLB
        * размер TLB обычно превосходит размер L1 кэша, иначе это имеет мало смысла (почему?)
    * про prefetch
        * подгружает в cache следующую линию за текущей
    * про написание программы-пробера.
        * stride/points probe
            * почему тестирование лучше всего проводить в виде pointer-chasing по заранее созданному массиву
                * не даёт компилятору сделать оптимизации по удалению неиспользуемого кода обращения
                * необходимо прописать `volatile` для итерируемого указателя
            * почему необходимо делать unrolling
            * `aligned_alloc`
            * про интерпретацию результатов таблички (с учётом влияния TLB)
            * алгоритм нахождения интересной точки (автоматическая интерпретация)
                * насчитываем baseline усредняя тесты с маленьким stride
                * ищем "плохую" точку, ниже и правее которой тоже "плохие"
                * выбираем среди всех таких с наименьшим stride * points
        * big step/small step probe
            * используется после первого теста, когда хотим определить размер линии
            * чередуем small step и big step.
              big step должен быть равен найденному stride
              small step должен быть равен предполагаемому размеру линии
            * если small step больше размера линии, то у теста 100% cache miss rate
            * в противном случае cache miss rate равен 50%

## Анонс (Устройство кэша данных)
Важную роль в быстродействии современных процессоров играет
устройство подсистемы памяти. На спецкурсе мы рассмотрим устройство L1 кэша данных,
понимание устройства которого является наиболее полезным при анализе производительности
программ. Конечной целью спецкурса является написание программы, тестирующей
характеристики L1 кэша данных процессора, на котором она запущена.
Специальных пререквизитов не требуется, но при выполнении практики
сильно поможет умение обращаться с инструментами, имеющими только консольный интерфейс.
